;----------------------------------------------------------------------------
;    MODULE NAME:   TryMeWithNonAdvShortcutPlusMore.MM
;
;        $Author:   USER "Dennis"  $
;      $Revision:   1.13  $
;          $Date:   22 Jun 2006 19:14:24  $
;       $Logfile:   C:/DBAREIS/Projects.PVCS/Win32/MakeMsi/TryMeWithNonAdvShortcutPlusMore.MM.pvcs  $
;
; DESCRIPTION
; ~~~~~~~~~~~
; Most complicated sample in that it does a few different things.
;
; You should probably have a look at and build "TryMe.MM" before this
; one!  Since it uses the same version file it shares update codes and all
; other information (product name etc).
;
; This shows one possible way of doing things, there are many ways (some
; better) - I tried to keep the example very simple.
; Note that I would generally use an advertised shortcut where possible.
;----------------------------------------------------------------------------

;--- Override some MAKEMSI options ------------------------------------------
#define VER_FILENAME.VER  TryMe.Ver  ;;I only want one VER file for all samples!
#define DEFAULT_FILE_DATE ?          ;;Stamp all installed files with current date
#define DEFAULT_FILE_TIME ?          ;;Stamp all installed files with current time

;--- Include MAKEMSI support (with my customisations and MSI branding) ------
#include "ME.MMH"


;--- Create INSTALLDIR (remember where user wishes it installed) ------------
<$Property "INSTALLDIR" Persist="Y" PersistHow="PRODUCT FOREVER">
<$DirectoryTree Key="INSTALLDIR" Dir="c:\program files\TryMe (makemsi sample)\<$MAKEMSI_MM_BASENAME>" CHANGE="\" PrimaryFolder="Y">


;--- Add files to a single component (mainly to differ from "tryMe.MM) ------
<$Component "TryMe" Create="Y" Directory_="INSTALLDIR">
    ;--- Add the file remember its rowkey and make keypath ------------------
    <$File Source="TryMeWithNonAdvShortcutPlusMore.MM" RowKey="StartMe" KeyPath="Y">
<$/Component>


;--- Create 9 copies of this script (create required component) -------------
<$DirectoryTree Key="COPIES9DIR" Dir="[INSTALLDIR]\Copies 9">
#{ for fc = 1 to 9
    ;--- Use todays date (and midnight) on these files ----------------------
    <$File Source="TryMeWithNonAdvShortcutPlusMore.MM" Destination="[COPIES9DIR]\COPY_<??fc>.txt" REMOVE="Y" DATE="?" TIME="00:00:00">
#}



;--- Create a subfeature ----------------------------------------------------
#(
   <$Feature "SomeFeatureNotInstalledByDefault"
            Directory_="INSTALLDIR"
                 Title="Some feature"
           Description=^Optional option feature.
                        This feature will not be installed by default.^
                 Level="5"         ;;Not installed by default
   >
#)
    ;--- Create some Registry entries via a simple macro --------------------
    <$Component "RegistryCu" Create="Y" Directory_="INSTALLDIR">
        ;--- Create a simple OPTIONS macro ----------------------------------
        #(
            #define OptionInRegistry
            <$Registry HKEY="CURRENT_USER" KEY="Software\TryMe\Options"
                       Name="{$Name}" VALUE="{$Value}" KeyPath="{$KeyPath='N'}"
            >
        #)

        ;--- Set some options -----------------------------------------------
        <$OptionInRegistry Name="Option1" VALUE="Value1" KeyPath="Y">
        <$OptionInRegistry Name="Option2" VALUE="Value2">
        <$OptionInRegistry Name="Option3" VALUE="Value3">
        <$OptionInRegistry Name="Option4" VALUE="Value4">
        <$OptionInRegistry Name="Option5" VALUE="Value5">

        ;--- Set some more options ------------------------------------------
        #Data Options 2
            ;--- Define information in "usage neutral" format (can use elsewhere (maybe other doco) ---
            'Option6'    'Value6'
            'Option7'    'Value7'
            'Option8'    'Value8'
            'Option9'    'Value9'
        #Data
        #{  FOR @@X = 1 to <?Data:Options.?>
            ;--- Process all data in the "#data" structure ------------------
            <$OptionInRegistry Name="<?Data:Options.@@X.1>" VALUE="<?Data:Options.@@X.1>">
        #}
    <$/Component>
<$/Feature>


;--- Display a message during a non-silent install (logs if silent) ---------
#data "PopupCaData"
   ;--- Some data we'd like to pass to the CA -------------------------------
   "InstallationDirectory" "[INSTALLDIR]"
   "SystemFolder" "[SystemFolder]"
#data
<$VbsCa Binary="Popup.vbs" DATA=^PopupCaData^>
   <$VbsCaEntry "HiThere">
       ;--- If the VBSCRIPT "MsgBox" or similar function was used this would prevent a silent install ---
       #(
            CaMsgBox "I",
                     "Hi this is a message from '<?InputFile>'! This was displayed via a VBSCRIPT MSI custom action." &
                     vbCRLF & vbCRLF &
                     "Note that I have enlarged this message box so that when an error occurs you will see the whole text! " &
                     "This and most tweeking MAKEMSI does to the user interface is optional (most performed by ""UISAMPLE.MMH"")." &
                     vbCRLF & vbCRLF &
                     "The installation directory is """ & VbsCaCadGet("InstallationDirectory") & """. " &
                     "The system directory is """       & VbsCaCadGet("SystemFolder")          & """."
       #)
   <$/VbsCaEntry>
<$/VbsCa>
<$VbsCaSetup Binary="Popup.vbs" Entry="HiThere" Seq="StartServices-" CONDITION=^<$CONDITION_INSTALL_ONLY>^ DATA=^PopupCaData^>


;--- Create a JSCRIPT CA to display a popup ---------------------------------
<$JsCa Binary="Popup.js">
    <$JsCaEntry "HiThere">
        CaMsgBox( "I",
                  'This is a simple message generated by some JSCRIPT running as an MSI custom action (Now early in uninstall).'
                 );
    <$/JsCaEntry>
<$/JsCa>
<$JsCaSetup Binary="Popup.js" Entry="HiThere" Seq="InstallValidate-" CONDITION=^<$CONDITION_UNINSTALL_ONLY>^ Type="immediate">


;--- Create a VBSCRIPT (perhaps using info only known during this install), syntax check it and add to MSI ---
<$FileMake "<$MAKEMSI_VBSCRIPT_DIR>\GeneratedVbscript.vbs">
    ;--- This shows how a file can be dynamically built (accessing build info etc) ---
    <?SyntaxCheck>
    #(
        MsgBox "This vbscript was generated automatically and
                installed via <$ProdInfo.ProductName> version
                <$ProductVersion>"
                ,vbInformation
                ,"GENERATED VBSCRIPT"
    #)
<$/FileMake>
<$Files "<$MAKEMSI_VBSCRIPT_DIR>\GeneratedVbscript.vbs" DestDir="INSTALLDIR">

